/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5222;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.client.render.text.Linebreaker;
import team.creative.creativecore.client.render.text.WidthLimitedCharSink;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.util.text.AdvancedComponentHelper;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.AdvancedContentConsumer;
import team.creative.creativecore.common.util.text.content.AdvancedFormattedText;
import team.creative.creativecore.common.util.type.list.SingletonList;

public class CompiledText {
    private int maxWidth;
    private int maxHeight;
    public int usedWidth;
    public int usedHeight;
    public int lineSpacing = 2;
    public boolean shadow = true;
    public int defaultColor = -1;
    public Align alignment = Align.LEFT;
    private List<CompiledLine> lines;
    private List<class_2561> original;

    private static int width(class_5348 text) {
        if (text instanceof AdvancedFormattedText) {
            AdvancedFormattedText adv = (AdvancedFormattedText)text;
            return adv.width(AdvancedComponentHelper.SPLITTER.width, class_2583.field_24360);
        }
        return class_3532.method_15386((float)AdvancedComponentHelper.SPLITTER.method_27488(text));
    }

    private static int lineHeight(class_5348 text) {
        class_2561 comp;
        class_7417 class_74172;
        if (text instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)text;
            return adv.height();
        }
        if (text instanceof class_2561 && (class_74172 = (comp = (class_2561)text).method_10851()) instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)class_74172;
            return adv.height();
        }
        return AdvancedComponentHelper.SPLITTER.lineHeight;
    }

    public CompiledText(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.setText(Collections.EMPTY_LIST);
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setDimension(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.compile();
    }

    public int getMaxWidht() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setText(class_2561 component) {
        this.setText(new SingletonList<class_2561>(component));
    }

    public void setText(List<class_2561> components) {
        this.original = components;
        this.compile();
    }

    private void compile() {
        if (CreativeCore.loader().getOverallSide().isServer()) {
            return;
        }
        ArrayList<class_2561> copy = new ArrayList<class_2561>();
        for (class_2561 component : this.original) {
            copy.add(AdvancedComponentHelper.copy(component));
        }
        this.lines = new ArrayList<CompiledLine>();
        this.compileNext(null, true, copy);
    }

    @Environment(value=EnvType.CLIENT)
    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, List<? extends class_5348> components) {
        for (class_5348 class_53482 : components) {
            if (newLine) {
                currentLine = new CompiledLine();
                this.lines.add(currentLine);
            }
            currentLine = this.compileNext(currentLine, class_53482);
        }
        return currentLine;
    }

    @Environment(value=EnvType.CLIENT)
    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, class_5348 component) {
        if (newLine) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
        }
        return this.compileNext(currentLine, component);
    }

    private CompiledLine compileNext(CompiledLine currentLine, class_5348 component) {
        class_5348 next;
        ArrayList siblings = null;
        if (component instanceof class_2561 && !((class_2561)component).method_10855().isEmpty()) {
            siblings = new ArrayList(((class_2561)component).method_10855());
            ((class_2561)component).method_10855().clear();
        }
        if ((next = currentLine.add(component)) != null) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
            currentLine = this.compileNext(currentLine, false, next);
        }
        if (siblings != null) {
            currentLine = this.compileNext(currentLine, false, siblings);
        }
        return currentLine;
    }

    @Environment(value=EnvType.CLIENT)
    public int getTotalHeight() {
        int height = -this.lineSpacing;
        for (CompiledLine line : this.lines) {
            height += line.height + this.lineSpacing;
        }
        return height;
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 stack) {
        if (this.lines == null) {
            return;
        }
        this.usedWidth = 0;
        this.usedHeight = -this.lineSpacing;
        stack.method_22903();
        for (CompiledLine line : this.lines) {
            switch (this.alignment) {
                case LEFT: {
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, line.width);
                    break;
                }
                case CENTER: {
                    stack.method_22903();
                    stack.method_22904((double)(this.maxWidth / 2 - line.width / 2), 0.0, 0.0);
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    stack.method_22909();
                    break;
                }
                case RIGHT: {
                    stack.method_22903();
                    stack.method_22904((double)(this.maxWidth - line.width), 0.0, 0.0);
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    stack.method_22909();
                    break;
                }
                case STRETCH: {
                    break;
                }
            }
            int height = line.height + this.lineSpacing;
            stack.method_22904(0.0, (double)height, 0.0);
            this.usedHeight += height;
            if (this.usedHeight <= this.maxHeight) continue;
            break;
        }
        stack.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public FormattedTextSplit splitByWidth(class_5348 text, int width, class_2583 style, final boolean force) {
        final WidthLimitedCharSink charSink = new WidthLimitedCharSink(width, class_310.method_1551().field_1772.method_27527());
        final class_5222 head = new class_5222();
        final class_5222 tail = new class_5222();
        if (text instanceof class_2561) {
            class_2561 comp = (class_2561)text;
            AdvancedComponentHelper.visit(comp, new AdvancedContentConsumer(){

                public Optional accept(class_2583 style, AdvancedContent content) {
                    if (charSink.accept(style, content) || force) {
                        head.method_27462(content.asText());
                    } else {
                        tail.method_27462(content.asText());
                    }
                    return Optional.empty();
                }

                public Optional accept(class_2583 style, String text) {
                    charSink.resetPosition();
                    if (!class_5223.method_27479((String)text, (class_2583)style, (class_5224)charSink)) {
                        Linebreaker breaker = charSink.lastBreaker();
                        if (force || breaker != null) {
                            String sTail;
                            String sHead;
                            if (breaker != null) {
                                int pos = charSink.lastBreakerPos();
                                sHead = text.substring(0, pos + (breaker.includeChar && breaker.head ? 1 : 0));
                                sTail = text.substring(pos + (breaker.includeChar && !breaker.head ? 0 : 1));
                            } else {
                                sHead = text.substring(0, charSink.getPosition());
                                sTail = text.substring(charSink.getPosition());
                            }
                            if (!sHead.isEmpty()) {
                                head.method_27462(class_5348.method_29431((String)sHead, (class_2583)style));
                            }
                            if (!sTail.isEmpty()) {
                                tail.method_27462(class_5348.method_29431((String)sTail, (class_2583)style));
                            }
                        } else {
                            tail.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                        }
                    } else if (!text.isEmpty()) {
                        head.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                    }
                    return Optional.empty();
                }
            }, style);
        } else {
            text.method_27658((class_5348.class_5246)new class_5348.class_5246<class_5348>(){

                public Optional<class_5348> accept(class_2583 style, String text) {
                    charSink.resetPosition();
                    if (!class_5223.method_27479((String)text, (class_2583)style, (class_5224)charSink)) {
                        Linebreaker breaker = charSink.lastBreaker();
                        if (force || breaker != null) {
                            String sTail;
                            String sHead;
                            if (breaker != null) {
                                int pos = charSink.lastBreakerPos();
                                sHead = text.substring(0, pos + (breaker.includeChar && breaker.head ? 1 : 0));
                                sTail = text.substring(pos + (breaker.includeChar && !breaker.head ? 0 : 1));
                            } else {
                                sHead = text.substring(0, charSink.getPosition());
                                sTail = text.substring(charSink.getPosition());
                            }
                            if (!sHead.isEmpty()) {
                                head.method_27462(class_5348.method_29431((String)sHead, (class_2583)style));
                            }
                            if (!sTail.isEmpty()) {
                                tail.method_27462(class_5348.method_29431((String)sTail, (class_2583)style));
                            }
                        } else {
                            tail.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                        }
                    } else if (!text.isEmpty()) {
                        head.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                    }
                    return Optional.empty();
                }
            }, style).orElse(null);
        }
        return new FormattedTextSplit(head, tail);
    }

    @Environment(value=EnvType.CLIENT)
    public int getTotalWidth() {
        return this.calculateWidth(0, true, this.original);
    }

    @Environment(value=EnvType.CLIENT)
    private int calculateWidth(int width, boolean newLine, List<? extends class_5348> components) {
        for (class_5348 class_53482 : components) {
            int result = CompiledText.width(class_53482);
            if (newLine) {
                width = Math.max(width, result);
                continue;
            }
            width += result;
        }
        return width;
    }

    public CompiledText copy() {
        CompiledText copy = new CompiledText(this.maxWidth, this.maxHeight);
        copy.alignment = this.alignment;
        copy.lineSpacing = this.lineSpacing;
        copy.shadow = this.shadow;
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        for (class_2561 component : this.original) {
            components.add((class_2561)component.method_27661());
        }
        copy.setText(components);
        return copy;
    }

    public static CompiledText createAnySize() {
        return new CompiledText(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public class CompiledLine {
        private List<class_5348> components = new ArrayList<class_5348>();
        private int height = 0;
        private int width = 0;

        @Environment(value=EnvType.CLIENT)
        public void render(class_4587 pose) {
            class_327 font = class_310.method_1551().field_1772;
            int xOffset = 0;
            class_4597.class_4598 renderType = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            for (class_5348 text : this.components) {
                int height = CompiledText.lineHeight(text);
                int width = CompiledText.width(text);
                int yOffset = 0;
                if (height < this.height) {
                    yOffset = (this.height - height) / 2;
                }
                pose.method_22903();
                pose.method_22904((double)xOffset, (double)yOffset, 0.0);
                if (text instanceof AdvancedFormattedText) {
                    AdvancedFormattedText adv = (AdvancedFormattedText)text;
                    adv.render(pose, CompiledText.this.defaultColor);
                } else {
                    font.method_22942(class_2477.method_10517().method_30934(text), 0.0f, 0.0f, CompiledText.this.defaultColor, CompiledText.this.shadow, pose.method_23760().method_23761(), (class_4597)renderType, false, 0, 0xF000F0);
                    renderType.method_22993();
                }
                pose.method_22909();
                xOffset += width;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void updateDimension(int width, int height) {
            this.width = Math.max(width, this.width);
            this.height = Math.max(height, this.height);
        }

        public class_5348 add(class_5348 component) {
            int remainingWidth = CompiledText.this.maxWidth - this.width;
            int textWidth = CompiledText.width(component);
            if (remainingWidth >= textWidth) {
                class_2561 comp;
                class_7417 class_74172;
                if (component instanceof class_2561 && (class_74172 = (comp = (class_2561)component).method_10851()) instanceof AdvancedContent) {
                    AdvancedContent adv = (AdvancedContent)class_74172;
                    this.components.add(adv.asText());
                } else {
                    this.components.add(component);
                }
                this.updateDimension(this.width + textWidth, CompiledText.lineHeight(component));
                return null;
            }
            FormattedTextSplit split = CompiledText.this.splitByWidth(component, remainingWidth, class_2583.field_24360, this.width == 0);
            if (split != null && (split.head != null || this.width == 0)) {
                if (split.head != null) {
                    this.updateDimension(this.width + CompiledText.width(split.head), CompiledText.lineHeight(split.head));
                    this.components.add(split.head);
                    return split.tail;
                }
                this.updateDimension(this.width + CompiledText.width(split.tail), CompiledText.lineHeight(split.tail));
                this.components.add(split.tail);
                return null;
            }
            return component;
        }
    }

    static class FormattedTextSplit {
        public final class_5348 head;
        public final class_5348 tail;

        public FormattedTextSplit(class_5348 head, class_5348 tail) {
            this.head = head;
            this.tail = tail;
        }

        public FormattedTextSplit(class_5222 head, class_5222 tail) {
            this.head = head.method_27461();
            this.tail = tail.method_27461();
        }
    }
}

